/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class PIBackupConsoleData {
    public static final String CMD_LINE_BUNDLE = "PIHscCmdLineBundle";
    public static final SimpleDateFormat TS_FORMATTER = new SimpleDateFormat("yyyyMMdd.HHmmss");
    private static final String FTP_PARAM = "ftp";
    private static final String DVD_PARAM = "dvd";
    private static final String NFS_PARAM = "nfs";
    private static final String[] FTP_PARAMS = new String[]{"-u", "--passwd"};
    private static final String[] NFS_PARAMS = new String[]{"-l", "-o"};
    private boolean writeToFTP;
    private boolean writeToDVD;
    private boolean writeToNFS;
    private String hostname;
    private String username;
    private String password;
    private String location;
    private String cmdopts;
    private static final int NUM_VALID_PARMS = 6;
    private HashMap m_validParms = new HashMap(13, 0.5f);

    private PIBackupConsoleData() {
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-h", null);
        this.m_validParms.put("-u", null);
        this.m_validParms.put("--passwd", null);
        this.m_validParms.put("-l", null);
        this.m_validParms.put("-o", null);
    }

    private void readPassword(PrintStream printStream) throws PIHscClientException {
        try {
            EExecResult eExecResult;
            String string = System.getProperty("HMCtty.name");
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            if (string != null && string != "") {
                eExecResult = EExec.Exec((String)("stty --save --file=" + string));
                string2 = "stty --file=" + string + " " + eExecResult.stdout;
                string3 = "stty --file=" + string + " -echo";
                bl = true;
            }
            Object[] objectArray = new String[]{this.username};
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            printStream.println(HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "ENTER_OLD_PASSWORD", null, objectArray));
            if (bl) {
                eExecResult = EExec.Exec(string3);
            }
            this.password = bufferedReader.readLine().trim();
            if (bl) {
                eExecResult = EExec.Exec((String)string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "ERROR_READING_PASSWORD");
        }
    }

    public int performCommand() throws PIHscClientException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(120);
        stringBuffer.append("/opt/hsc/bin/backuphdr ");
        stringBuffer.append("HMCBackup_").append(TS_FORMATTER.format(new Date())).append(".tgz");
        if (this.writeToDVD) {
            stringBuffer.append(" 0");
        } else if (this.writeToNFS) {
            stringBuffer.append(" 1 ").append(this.hostname).append(" ").append(this.location);
            if (this.cmdopts != null) {
                stringBuffer.append(" \"").append(this.cmdopts).append('\"');
            }
        } else if (this.writeToFTP) {
            stringBuffer.append(" 2 ").append(this.hostname).append(" ").append(this.username);
            stringBuffer.append(" ").append(this.password);
        }
        try {
            Process process = Runtime.getRuntime().exec(stringBuffer.toString());
            n = process.waitFor();
        }
        catch (Throwable throwable) {
            throw new PIHscClientException("8016", CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR", null, null);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mapParameters(HashMap hashMap, PrintStream printStream) throws PIHscClientException {
        this.writeToFTP = false;
        this.writeToDVD = false;
        this.writeToNFS = false;
        String string = (String)hashMap.get("-r");
        this.hostname = (String)hashMap.get("-h");
        this.username = (String)hashMap.get("-u");
        this.password = (String)hashMap.get("--passwd");
        this.location = (String)hashMap.get("-l");
        this.cmdopts = (String)hashMap.get("-o");
        if (string == null) {
            String[] stringArray = new String[]{"-r"};
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if ((string = string.trim()).equals(FTP_PARAM)) {
            this.writeToFTP = true;
        } else if (string.equals(DVD_PARAM)) {
            this.writeToDVD = true;
        } else {
            if (!string.equals(NFS_PARAM)) {
                String[] stringArray = new String[]{"-r"};
                throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "INVALID_PARM_VALUE", stringArray, null);
            }
            this.writeToNFS = true;
        }
        if (this.writeToDVD) {
            PIHMCCommandUtils.checkInvalidCombination(hashMap, FTP_PARAMS);
            PIHMCCommandUtils.checkInvalidCombination(hashMap, NFS_PARAMS);
        }
        if (this.writeToFTP) {
            if (this.hostname == null) {
                String[] stringArray = new String[]{"-h"};
                throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            this.hostname = this.hostname.trim();
            if (this.username == null) {
                String[] stringArray = new String[]{"-u"};
                throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            this.username = this.username.trim();
            if (this.password != null) {
                this.password = this.password.trim();
            } else {
                this.readPassword(printStream);
            }
            PIHMCCommandUtils.checkInvalidCombination(hashMap, NFS_PARAMS);
            return;
        }
        if (!this.writeToNFS) return;
        if (this.hostname == null) {
            String[] stringArray = new String[]{"-h"};
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        this.hostname = this.hostname.trim();
        if (this.location == null) {
            String[] stringArray = new String[]{"-u"};
            throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        this.location = this.location.trim();
        this.cmdopts = this.cmdopts != null ? this.cmdopts.trim() : "";
        PIHMCCommandUtils.checkInvalidCombination(hashMap, FTP_PARAMS);
    }

    public void printResults(int n, PrintStream printStream) {
    }

    public static void printHelp(PrintStream printStream) {
        printStream.println(HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "BKCONSDATA_HELP"));
    }

    public static void main(String[] stringArray) {
        int n;
        String[] stringArray2;
        boolean bl = false;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = null;
        int n2 = 0;
        PIHscUtil.initHscUtil(3);
        PIBackupConsoleData pIBackupConsoleData = new PIBackupConsoleData();
        try {
            stringArray2 = null;
            if (0 == stringArray.length) {
                PIBackupConsoleData.printHelp(System.out);
                bl = true;
            }
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2 = stringArray[n];
                arrayList.add(stringArray2);
                if (!stringArray2.equals("--help")) continue;
                PIBackupConsoleData.printHelp(System.out);
                bl = true;
                break;
            }
            if (!bl) {
                HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIBackupConsoleData.m_validParms);
                pIBackupConsoleData.mapParameters(hashMap, System.out);
                n2 = pIBackupConsoleData.performCommand();
                pIBackupConsoleData.printResults(n2, System.out);
            }
        }
        catch (PIHscClientException pIHscClientException) {
            if ("8000".equals(pIHscClientException.getHscExId())) {
                System.out.println(pIHscClientException.getMessage());
            } else {
                pIHscClientException.printStackTrace(System.out);
                string = pIHscClientException.getMessage();
                if (string == null) {
                    string = HSCResourceBundleUtil.getMessage(CMD_LINE_BUNDLE, "COMMAND_LINE_ERROR");
                }
                System.out.println(string);
            }
            n2 = 1;
        }
        try {
            stringArray2 = new String[]{"bkconsdata"};
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[0] = stringArray2[0] + " " + stringArray[n];
                if (!stringArray[n].equals("--passwd") || n >= stringArray.length - 1 || stringArray[n + 1].startsWith("-")) continue;
                stringArray2[0] = stringArray2[0] + " ********";
                ++n;
            }
            if (n2 == 0) {
                HSCLogUtils.logSystemEvent((short)2123, "", stringArray2, PIHscUtil.getOriginalUser());
            } else {
                HSCLogUtils.logSystemEvent((short)2124, "", stringArray2, PIHscUtil.getOriginalUser());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(n2);
    }
}

